/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Supplier;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class FlatWindowResizer
implements PropertyChangeListener,
ComponentListener {
    protected static final Integer WINDOW_RESIZER_LAYER = JLayeredPane.DRAG_LAYER + 1;
    protected final JComponent resizeComp;
    protected final int borderDragThickness = FlatUIUtils.getUIInt("RootPane.borderDragThickness", 5);
    protected final int cornerDragWidth = FlatUIUtils.getUIInt("RootPane.cornerDragWidth", 16);
    protected final boolean honorFrameMinimumSizeOnResize = UIManager.getBoolean("RootPane.honorFrameMinimumSizeOnResize");
    protected final boolean honorDialogMinimumSizeOnResize = UIManager.getBoolean("RootPane.honorDialogMinimumSizeOnResize");
    protected final DragBorderComponent topDragComp;
    protected final DragBorderComponent bottomDragComp;
    protected final DragBorderComponent leftDragComp;
    protected final DragBorderComponent rightDragComp;

    protected FlatWindowResizer(JComponent resizeComp) {
        this.resizeComp = resizeComp;
        this.topDragComp = this.createDragBorderComponent(6, 8, 7);
        this.bottomDragComp = this.createDragBorderComponent(4, 9, 5);
        this.leftDragComp = this.createDragBorderComponent(6, 10, 4);
        this.rightDragComp = this.createDragBorderComponent(7, 11, 5);
        JComponent cont = resizeComp instanceof JRootPane ? ((JRootPane)resizeComp).getLayeredPane() : resizeComp;
        Integer cons = cont instanceof JLayeredPane ? WINDOW_RESIZER_LAYER : null;
        cont.add(this.topDragComp, cons, 0);
        cont.add(this.bottomDragComp, cons, 1);
        cont.add(this.leftDragComp, cons, 2);
        cont.add(this.rightDragComp, cons, 3);
        resizeComp.addComponentListener(this);
        resizeComp.addPropertyChangeListener("ancestor", this);
        if (resizeComp.isDisplayable()) {
            this.addNotify();
        }
    }

    protected DragBorderComponent createDragBorderComponent(int leadingResizeDir, int centerResizeDir, int trailingResizeDir) {
        return new DragBorderComponent(leadingResizeDir, centerResizeDir, trailingResizeDir);
    }

    public void uninstall() {
        this.removeNotify();
        this.resizeComp.removeComponentListener(this);
        this.resizeComp.removePropertyChangeListener("ancestor", this);
        Container cont = this.topDragComp.getParent();
        cont.remove(this.topDragComp);
        cont.remove(this.bottomDragComp);
        cont.remove(this.leftDragComp);
        cont.remove(this.rightDragComp);
    }

    public void doLayout() {
        if (!this.topDragComp.isVisible()) {
            return;
        }
        int x2 = 0;
        int y2 = 0;
        int width = this.resizeComp.getWidth();
        int height = this.resizeComp.getHeight();
        if (width == 0 || height == 0) {
            return;
        }
        Insets resizeInsets = this.getResizeInsets();
        int thickness = UIScale.scale(this.borderDragThickness);
        int topThickness = Math.max(resizeInsets.top, thickness);
        int bottomThickness = Math.max(resizeInsets.bottom, thickness);
        int leftThickness = Math.max(resizeInsets.left, thickness);
        int rightThickness = Math.max(resizeInsets.right, thickness);
        int y22 = y2 + topThickness;
        int height2 = height - topThickness - bottomThickness;
        this.topDragComp.setBounds(x2, y2, width, topThickness);
        this.bottomDragComp.setBounds(x2, y2 + height - bottomThickness, width, bottomThickness);
        this.leftDragComp.setBounds(x2, y22, leftThickness, height2);
        this.rightDragComp.setBounds(x2 + width - rightThickness, y22, rightThickness, height2);
        int cornerDelta = UIScale.scale(this.cornerDragWidth - this.borderDragThickness);
        this.topDragComp.setCornerDragWidths(leftThickness + cornerDelta, rightThickness + cornerDelta);
        this.bottomDragComp.setCornerDragWidths(leftThickness + cornerDelta, rightThickness + cornerDelta);
        this.leftDragComp.setCornerDragWidths(cornerDelta, cornerDelta);
        this.rightDragComp.setCornerDragWidths(cornerDelta, cornerDelta);
    }

    protected Insets getResizeInsets() {
        return new Insets(0, 0, 0, 0);
    }

    protected void addNotify() {
        this.updateVisibility();
    }

    protected void removeNotify() {
        this.updateVisibility();
    }

    protected void updateVisibility() {
        boolean visible = this.isWindowResizable();
        if (visible == this.topDragComp.isVisible()) {
            return;
        }
        this.topDragComp.setVisible(visible);
        this.bottomDragComp.setVisible(visible);
        this.leftDragComp.setVisible(visible);
        this.rightDragComp.setEnabled(visible);
        if (visible) {
            this.rightDragComp.setVisible(true);
            this.doLayout();
        } else {
            this.rightDragComp.setBounds(0, 0, 1, 1);
        }
    }

    boolean isDialog() {
        return false;
    }

    protected abstract boolean isWindowResizable();

    protected abstract Rectangle getWindowBounds();

    protected abstract void setWindowBounds(Rectangle var1);

    protected abstract boolean limitToParentBounds();

    protected abstract Rectangle getParentBounds();

    protected abstract boolean honorMinimumSizeOnResize();

    protected abstract boolean honorMaximumSizeOnResize();

    protected abstract Dimension getWindowMinimumSize();

    protected abstract Dimension getWindowMaximumSize();

    protected void beginResizing(int direction) {
    }

    protected void endResizing() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        switch (e2.getPropertyName()) {
            case "ancestor": {
                if (e2.getNewValue() != null) {
                    this.addNotify();
                    break;
                }
                this.removeNotify();
                break;
            }
            case "resizable": {
                this.updateVisibility();
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e2) {
        this.doLayout();
    }

    @Override
    public void componentMoved(ComponentEvent e2) {
    }

    @Override
    public void componentShown(ComponentEvent e2) {
    }

    @Override
    public void componentHidden(ComponentEvent e2) {
    }

    protected class DragBorderComponent
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private final int leadingResizeDir;
        private final int centerResizeDir;
        private final int trailingResizeDir;
        private int resizeDir = -1;
        private int leadingCornerDragWidth;
        private int trailingCornerDragWidth;
        private int dragLeftOffset;
        private int dragRightOffset;
        private int dragTopOffset;
        private int dragBottomOffset;

        protected DragBorderComponent(int leadingResizeDir, int centerResizeDir, int trailingResizeDir) {
            this.leadingResizeDir = leadingResizeDir;
            this.centerResizeDir = centerResizeDir;
            this.trailingResizeDir = trailingResizeDir;
            this.setResizeDir(centerResizeDir);
            this.setVisible(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        void setCornerDragWidths(int leading, int trailing) {
            this.leadingCornerDragWidth = leading;
            this.trailingCornerDragWidth = trailing;
        }

        protected void setResizeDir(int resizeDir) {
            if (this.resizeDir == resizeDir) {
                return;
            }
            this.resizeDir = resizeDir;
            this.setCursor(Cursor.getPredefinedCursor(resizeDir));
        }

        @Override
        public Dimension getPreferredSize() {
            int thickness = UIScale.scale(FlatWindowResizer.this.borderDragThickness);
            return new Dimension(thickness, thickness);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            super.paintChildren(g2);
            FlatWindowResizer.this.updateVisibility();
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (!SwingUtilities.isLeftMouseButton(e2) || !FlatWindowResizer.this.isWindowResizable()) {
                return;
            }
            int xOnScreen = e2.getXOnScreen();
            int yOnScreen = e2.getYOnScreen();
            Rectangle windowBounds = FlatWindowResizer.this.getWindowBounds();
            this.dragLeftOffset = xOnScreen - windowBounds.x;
            this.dragTopOffset = yOnScreen - windowBounds.y;
            this.dragRightOffset = windowBounds.x + windowBounds.width - xOnScreen;
            this.dragBottomOffset = windowBounds.y + windowBounds.height - yOnScreen;
            int direction = 0;
            switch (this.resizeDir) {
                case 8: {
                    direction = 1;
                    break;
                }
                case 9: {
                    direction = 5;
                    break;
                }
                case 10: {
                    direction = 7;
                    break;
                }
                case 11: {
                    direction = 3;
                    break;
                }
                case 6: {
                    direction = 8;
                    break;
                }
                case 7: {
                    direction = 2;
                    break;
                }
                case 4: {
                    direction = 6;
                    break;
                }
                case 5: {
                    direction = 4;
                }
            }
            FlatWindowResizer.this.beginResizing(direction);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (!SwingUtilities.isLeftMouseButton(e2) || !FlatWindowResizer.this.isWindowResizable()) {
                return;
            }
            this.dragBottomOffset = 0;
            this.dragTopOffset = 0;
            this.dragRightOffset = 0;
            this.dragLeftOffset = 0;
            FlatWindowResizer.this.endResizing();
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            int wh;
            boolean topOrBottom = this.centerResizeDir == 8 || this.centerResizeDir == 9;
            int xy = topOrBottom ? e2.getX() : e2.getY();
            int n2 = wh = topOrBottom ? this.getWidth() : this.getHeight();
            this.setResizeDir(xy <= this.leadingCornerDragWidth ? this.leadingResizeDir : (xy >= wh - this.trailingCornerDragWidth ? this.trailingResizeDir : this.centerResizeDir));
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            Dimension minimumSize;
            Rectangle parentBounds;
            if (!SwingUtilities.isLeftMouseButton(e2) || !FlatWindowResizer.this.isWindowResizable()) {
                return;
            }
            int xOnScreen = e2.getXOnScreen();
            int yOnScreen = e2.getYOnScreen();
            Rectangle oldBounds = FlatWindowResizer.this.getWindowBounds();
            Rectangle newBounds = new Rectangle(oldBounds);
            if (this.resizeDir == 8 || this.resizeDir == 6 || this.resizeDir == 7) {
                newBounds.y = yOnScreen - this.dragTopOffset;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    newBounds.y = Math.max(newBounds.y, FlatWindowResizer.this.getParentBounds().y);
                }
                newBounds.height += oldBounds.y - newBounds.y;
            }
            if (this.resizeDir == 9 || this.resizeDir == 4 || this.resizeDir == 5) {
                newBounds.height = yOnScreen + this.dragBottomOffset - newBounds.y;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    parentBounds = FlatWindowResizer.this.getParentBounds();
                    int parentBottomY = parentBounds.y + parentBounds.height;
                    if (newBounds.y + newBounds.height > parentBottomY) {
                        newBounds.height = parentBottomY - newBounds.y;
                    }
                }
            }
            if (this.resizeDir == 10 || this.resizeDir == 6 || this.resizeDir == 4) {
                newBounds.x = xOnScreen - this.dragLeftOffset;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    newBounds.x = Math.max(newBounds.x, FlatWindowResizer.this.getParentBounds().x);
                }
                newBounds.width += oldBounds.x - newBounds.x;
            }
            if (this.resizeDir == 11 || this.resizeDir == 7 || this.resizeDir == 5) {
                newBounds.width = xOnScreen + this.dragRightOffset - newBounds.x;
                if (FlatWindowResizer.this.limitToParentBounds()) {
                    parentBounds = FlatWindowResizer.this.getParentBounds();
                    int parentRightX = parentBounds.x + parentBounds.width;
                    if (newBounds.x + newBounds.width > parentRightX) {
                        newBounds.width = parentRightX - newBounds.x;
                    }
                }
            }
            Dimension dimension = minimumSize = FlatWindowResizer.this.honorMinimumSizeOnResize() ? FlatWindowResizer.this.getWindowMinimumSize() : null;
            if (minimumSize == null) {
                minimumSize = UIScale.scale(new Dimension(150, 50));
            }
            if (newBounds.width < minimumSize.width) {
                this.changeWidth(oldBounds, newBounds, minimumSize.width);
            }
            if (newBounds.height < minimumSize.height) {
                this.changeHeight(oldBounds, newBounds, minimumSize.height);
            }
            if (FlatWindowResizer.this.honorMaximumSizeOnResize()) {
                Dimension maximumSize = FlatWindowResizer.this.getWindowMaximumSize();
                if (newBounds.width > maximumSize.width) {
                    this.changeWidth(oldBounds, newBounds, maximumSize.width);
                }
                if (newBounds.height > maximumSize.height) {
                    this.changeHeight(oldBounds, newBounds, maximumSize.height);
                }
            }
            if (!newBounds.equals(oldBounds)) {
                FlatWindowResizer.this.setWindowBounds(newBounds);
            }
        }

        private void changeWidth(Rectangle oldBounds, Rectangle newBounds, int width) {
            if (newBounds.x != oldBounds.x) {
                newBounds.x -= width - newBounds.width;
            }
            newBounds.width = width;
        }

        private void changeHeight(Rectangle oldBounds, Rectangle newBounds, int height) {
            if (newBounds.y != oldBounds.y) {
                newBounds.y -= height - newBounds.height;
            }
            newBounds.height = height;
        }
    }

    public static class InternalFrameResizer
    extends FlatWindowResizer {
        protected final Supplier<DesktopManager> desktopManager;

        public InternalFrameResizer(JInternalFrame frame, Supplier<DesktopManager> desktopManager) {
            super(frame);
            this.desktopManager = desktopManager;
            frame.addPropertyChangeListener("resizable", this);
        }

        @Override
        public void uninstall() {
            this.getFrame().removePropertyChangeListener("resizable", this);
            super.uninstall();
        }

        private JInternalFrame getFrame() {
            return (JInternalFrame)this.resizeComp;
        }

        @Override
        protected Insets getResizeInsets() {
            return this.getFrame().getInsets();
        }

        @Override
        protected boolean isWindowResizable() {
            return this.getFrame().isResizable();
        }

        @Override
        protected Rectangle getWindowBounds() {
            return this.getFrame().getBounds();
        }

        @Override
        protected void setWindowBounds(Rectangle r2) {
            this.desktopManager.get().resizeFrame(this.getFrame(), r2.x, r2.y, r2.width, r2.height);
        }

        @Override
        protected boolean limitToParentBounds() {
            return true;
        }

        @Override
        protected Rectangle getParentBounds() {
            return new Rectangle(this.getFrame().getParent().getSize());
        }

        @Override
        protected boolean honorMinimumSizeOnResize() {
            return true;
        }

        @Override
        protected boolean honorMaximumSizeOnResize() {
            return true;
        }

        @Override
        protected Dimension getWindowMinimumSize() {
            return this.getFrame().getMinimumSize();
        }

        @Override
        protected Dimension getWindowMaximumSize() {
            return this.getFrame().getMaximumSize();
        }

        @Override
        protected void beginResizing(int direction) {
            this.desktopManager.get().beginResizingFrame(this.getFrame(), direction);
        }

        @Override
        protected void endResizing() {
            this.desktopManager.get().endResizingFrame(this.getFrame());
        }
    }

    public static class WindowResizer
    extends FlatWindowResizer
    implements WindowStateListener {
        protected Window window;
        private final boolean limitResizeToScreenBounds = SystemInfo.isLinux;

        public WindowResizer(JRootPane rootPane) {
            super(rootPane);
        }

        @Override
        protected void addNotify() {
            Container parent = this.resizeComp.getParent();
            Window window = this.window = parent instanceof Window ? (Window)parent : null;
            if (this.window instanceof Frame) {
                this.window.addPropertyChangeListener("resizable", this);
                this.window.addWindowStateListener(this);
            }
            super.addNotify();
        }

        @Override
        protected void removeNotify() {
            if (this.window instanceof Frame) {
                this.window.removePropertyChangeListener("resizable", this);
                this.window.removeWindowStateListener(this);
            }
            this.window = null;
            super.removeNotify();
        }

        @Override
        protected boolean isWindowResizable() {
            if (FlatUIUtils.isFullScreen(this.resizeComp)) {
                return false;
            }
            if (this.window instanceof Frame) {
                return ((Frame)this.window).isResizable() && (((Frame)this.window).getExtendedState() & 6) == 0;
            }
            if (this.window instanceof Dialog) {
                return ((Dialog)this.window).isResizable();
            }
            return false;
        }

        @Override
        protected Rectangle getWindowBounds() {
            return this.window.getBounds();
        }

        @Override
        protected void setWindowBounds(Rectangle r2) {
            this.window.setBounds(r2);
            this.doLayout();
            if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                this.window.validate();
                this.resizeComp.repaint();
            }
        }

        @Override
        protected boolean limitToParentBounds() {
            return this.limitResizeToScreenBounds && this.window != null;
        }

        @Override
        protected Rectangle getParentBounds() {
            if (this.limitResizeToScreenBounds && this.window != null) {
                GraphicsConfiguration gc2 = this.window.getGraphicsConfiguration();
                Rectangle bounds = gc2.getBounds();
                Insets insets = this.window.getToolkit().getScreenInsets(gc2);
                return new Rectangle(bounds.x + insets.left, bounds.y + insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
            }
            return null;
        }

        @Override
        protected boolean honorMinimumSizeOnResize() {
            return this.honorFrameMinimumSizeOnResize && this.window instanceof Frame || this.honorDialogMinimumSizeOnResize && this.window instanceof Dialog;
        }

        @Override
        protected boolean honorMaximumSizeOnResize() {
            return false;
        }

        @Override
        protected Dimension getWindowMinimumSize() {
            return this.window.getMinimumSize();
        }

        @Override
        protected Dimension getWindowMaximumSize() {
            return this.window.getMaximumSize();
        }

        @Override
        boolean isDialog() {
            return this.window instanceof Dialog;
        }

        @Override
        public void windowStateChanged(WindowEvent e2) {
            this.updateVisibility();
        }
    }
}

